<div class="d-flex justify-content-between align-items-center mb-3">
    <h3 class="fw-bold m-0">Absensi Harian Siswa</h3>
    <a href="?page=absensi_rekap" class="btn btn-outline-primary">
        <i class="bi bi-table me-1"></i> Lihat Rekap Bulanan
    </a>
</div>

<div class="card border-0 shadow-sm mb-4">
    <div class="card-body">
        <!-- FORM FILTER (Pilih Kelas & Tanggal) -->
        <form method="GET" action="dashboard.php">
            <input type="hidden" name="page" value="absensi">
            <div class="row g-2 align-items-end">
                <div class="col-md-4">
                    <label class="fw-bold mb-1">Pilih Kelas</label>
                    <select name="kelas" class="form-select" required>
                        <option value="">-- Pilih Kelas --</option>
                        <option value="X-A" <?php if(isset($_GET['kelas']) && $_GET['kelas']=='X-A') echo 'selected'; ?>>X-A</option>
                        <option value="X-B" <?php if(isset($_GET['kelas']) && $_GET['kelas']=='X-B') echo 'selected'; ?>>X-B</option>
                        <option value="XI-IPA" <?php if(isset($_GET['kelas']) && $_GET['kelas']=='XI-IPA') echo 'selected'; ?>>XI-IPA</option>
                        <option value="XI-IPS" <?php if(isset($_GET['kelas']) && $_GET['kelas']=='XI-IPS') echo 'selected'; ?>>XI-IPS</option>
                        <option value="XII-IPA" <?php if(isset($_GET['kelas']) && $_GET['kelas']=='XII-IPA') echo 'selected'; ?>>XII-IPA</option>
                        <option value="XII-IPS" <?php if(isset($_GET['kelas']) && $_GET['kelas']=='XII-IPS') echo 'selected'; ?>>XII-IPS</option>
                    </select>
                </div>
                <div class="col-md-4">
                    <label class="fw-bold mb-1">Tanggal</label>
                    <input type="date" name="tanggal" class="form-control" value="<?php echo isset($_GET['tanggal']) ? $_GET['tanggal'] : date('Y-m-d'); ?>" required>
                </div>
                <div class="col-md-2">
                    <button type="submit" class="btn btn-primary w-100 fw-bold">Tampilkan</button>
                </div>
            </div>
        </form>
    </div>
</div>

<?php
// JIKA TOMBOL TAMPILKAN SUDAH DIKLIK
if (isset($_GET['kelas']) && isset($_GET['tanggal'])) {
    $kelas = $_GET['kelas'];
    $tgl   = $_GET['tanggal'];
?>
    <div class="card border-0 shadow-sm">
        <div class="card-header bg-white">
            <h5 class="m-0">Input Absensi Kelas: <b><?= $kelas ?></b> <small class="text-muted ms-2">(<?= date('d-m-Y', strtotime($tgl)) ?>)</small></h5>
        </div>
        
        <!-- Form Simpan Absen arahkan ke Proses -->
        <form method="POST" action="proses/act_absensi.php">
            <input type="hidden" name="tanggal" value="<?= $tgl ?>">
            <input type="hidden" name="kelas" value="<?= $kelas ?>">

            <div class="card-body p-0">
                <table class="table table-hover table-striped mb-0">
                    <thead class="table-dark">
                        <tr>
                            <th width="50">No</th>
                            <th>Nama Siswa</th>
                            <th class="text-center" width="300">Keterangan</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $no = 1;
                        // Ambil siswa berdasarkan kelas yang dipilih
                        $q = mysqli_query($koneksi, "SELECT * FROM siswa WHERE kelas='$kelas' AND status='Aktif' ORDER BY nama ASC");
                        
                        if(mysqli_num_rows($q) > 0) {
                            while ($d = mysqli_fetch_array($q)) {
                        ?>
                            <tr>
                                <td><?= $no++ ?></td>
                                <td>
                                    <b><?= $d['nama'] ?></b>
                                    <input type="hidden" name="id_siswa[]" value="<?= $d['id'] ?>">
                                </td>
                                <td class="text-center">
                                    <!-- Radio Button Unik per Siswa (Array) -->
                                    <div class="btn-group" role="group">
                                        <input type="radio" class="btn-check" name="ket[<?= $d['id'] ?>]" value="H" id="h<?= $d['id'] ?>" checked>
                                        <label class="btn btn-outline-success btn-sm" for="h<?= $d['id'] ?>">Hadir</label>

                                        <input type="radio" class="btn-check" name="ket[<?= $d['id'] ?>]" value="I" id="i<?= $d['id'] ?>">
                                        <label class="btn btn-outline-primary btn-sm" for="i<?= $d['id'] ?>">Izin</label>

                                        <input type="radio" class="btn-check" name="ket[<?= $d['id'] ?>]" value="S" id="s<?= $d['id'] ?>">
                                        <label class="btn btn-outline-warning btn-sm" for="s<?= $d['id'] ?>">Sakit</label>

                                        <input type="radio" class="btn-check" name="ket[<?= $d['id'] ?>]" value="A" id="a<?= $d['id'] ?>">
                                        <label class="btn btn-outline-danger btn-sm" for="a<?= $d['id'] ?>">Alpha</label>
                                    </div>
                                </td>
                            </tr>
                        <?php 
                            } 
                        } else {
                            echo "<tr><td colspan='3' class='text-center py-4 text-muted'>Belum ada siswa di kelas ini.</td></tr>";
                        }
                        ?>
                    </tbody>
                </table>
            </div>
            
            <?php if(mysqli_num_rows($q) > 0) { ?>
            <div class="card-footer bg-white text-end">
                <button type="submit" name="simpan_absensi" class="btn btn-success fw-bold">
                    <i class="bi bi-save me-1"></i> Simpan Data Absensi
                </button>
            </div>
            <?php } ?>
        </form>
    </div>
<?php } ?>